<?php


namespace App\Http\Controllers;

use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class SupplierController extends Controller
{
    // نمایش فرم ثبت تامین‌کننده جدید
    public function create()
    {
        return view('suppliers.create');
    }

    // ذخیره اطلاعات تامین‌کننده در پایگاه داده
    public function store(Request $request)
    {
        // اعتبار سنجی اطلاعات ورودی
        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255', Rule::unique('suppliers', 'name')],
            'contact_person' => ['nullable', 'string', 'max:255'],
            'phone' => ['nullable', 'string', 'max:255'],
            'email' => ['nullable', 'email', 'max:255'],
        ]);

        // ذخیره در پایگاه داده
        Supplier::create($validated);

        // نمایش پیام موفقیت
        return redirect()->route('suppliers.create')->with('status', 'تامین‌کننده با موفقیت ثبت شد!');
    }
}