<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد اصلی</title>
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('{{ asset('fonts/Vazirmatn-Regular.woff2') }}') format('woff2');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'Vazirmatn', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            width: 90%;
            max-width: 800px;
            text-align: center;
        }
        .header {
            margin-bottom: 40px;
        }
        .header h1 {
            color: #2c3e50;
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        .header p {
            color: #7f8c8d;
            font-size: 1.1rem;
        }
        .card-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
        }
        .card {
            background-color: #ecf0f1;
            border-radius: 10px;
            padding: 30px;
            width: calc(50% - 10px);
            text-decoration: none;
            color: #34495e;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s, box-shadow 0.3s;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        .card h3 {
            margin-top: 10px;
            font-size: 1.3rem;
            font-weight: bold;
        }
        .card p {
            font-size: 0.9rem;
            color: #7f8c8d;
        }
        .logout-link {
            margin-top: 40px;
            font-size: 1rem;
        }
        .logout-link a {
            color: #e74c3c;
            text-decoration: none;
            font-weight: bold;
            transition: color 0.3s;
        }
        .logout-link a:hover {
            color: #c0392b;
        }
        /* Icon styles */
        .icon-wrapper {
            background-color: #3498db;
            border-radius: 50%;
            padding: 15px;
            width: 60px;
            height: 60px;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
            font-size: 2rem;
        }
        .card[href*="purchases"] .icon-wrapper { background-color: #3498db; }
        .card[href*="sales"] .icon-wrapper { background-color: #2ecc71; }
        .card[href*="suppliers"] .icon-wrapper { background-color: #f1c40f; }

        @media (max-width: 600px) {
            .card {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>به داشبورد اصلی خوش آمدید، {{ Auth::user()->name }}</h1>
            <p>لطفاً یک گزینه را برای ادامه انتخاب کنید.</p>
        </div>
        
        <div class="card-container">
            @if (Auth::user()->role === 'purchase')
                <a href="{{ route('purchases.create') }}" class="card">
                    <div class="icon-wrapper">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3>ثبت خرید جدید</h3>
                    <p>یک خرید جدید برای تیم خود ثبت کنید.</p>
                </a>
                <a href="{{ route('purchases.index') }}" class="card">
                    <div class="icon-wrapper">
                        <i class="fas fa-list"></i>
                    </div>
                    <h3>لیست خریدها</h3>
                    <p>تمام خریدهای ثبت شده را مشاهده و مدیریت کنید.</p>
                </a>
                <a href="{{ route('suppliers.create') }}" class="card">
                    <div class="icon-wrapper">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>ثبت تامین‌کننده</h3>
                    <p>یک تامین‌کننده جدید به سیستم اضافه کنید.</p>
                </a>
            @endif
            
            @if (Auth::user()->role === 'sales')
                <a href="{{ route('sales.create') }}" class="card">
                    <div class="icon-wrapper">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h3>ثبت فروش جدید</h3>
                    <p>یک فروش جدید را ثبت و به خریدها تخصیص دهید.</p>
                </a>
                <a href="{{ route('sales.index') }}" class="card">
                    <div class="icon-wrapper">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>لیست فروش‌ها</h3>
                    <p>تمام فروش‌های ثبت شده را بررسی کنید.</p>
                </a>
            @endif
        </div>
        
        <div class="logout-link">
            <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                خروج از سیستم
            </a>
        </div>
        
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js"></script>
</body>
</html>