@extends('layouts.app')

@section('title', 'عنوان صفحه')

@section('styles')
<style>
    body {
        font-family: 'B Nazanin', sans-serif;
        background-color: #f4f7f6;
        margin: 0;
        padding: 20px;
    }

    .container {
        max-width: 900px;
        margin: 0 auto;
        background-color: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    h1 {
        text-align: center;
        color: #333;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    th,
    td {
        border: 1px solid #ddd;
        padding: 12px;
        text-align: center;
    }

    th {
        background-color: #f2f2f2;
        color: #555;
    }

    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    tr:hover {
        background-color: #f1f1f1;
    }

    a {
        text-decoration: none;
        color: #3498db;
        font-weight: bold;
    }

    a:hover {
        color: #2980b9;
    }

    .badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: bold;
    }

    .badge.pending {
        background-color: #f39c12;
        color: white;
    }

    .badge.paid {
        background-color: #2ecc71;
        color: white;
    }

    .total-info {
        text-align: left;
        font-size: 1.1em;
        font-weight: bold;
        margin-top: 20px;
    }
</style>
@endsection

@section('scripts')
<script>
    
</script>
@endsection

@section('content')


     <div class="container">
        <h1>لیست خریدها</h1>

        <table>
            <thead>
                <tr>
                    <th>شناسه</th>
                    <th>تامین‌کننده</th>
                    <th>مبلغ کل</th>
                    <th>مبلغ اختصاص یافته</th>
                    <th>مبلغ باقیمانده</th>
                    <th>وضعیت</th>
                    <th>تاریخ ثبت</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($purchases as $purchase)
                <tr>
                    <td>{{ $purchase->id }}</td>
                    <td>{{ $purchase->supplier->name }}</td>
                    <td>{{ number_format($purchase->total_amount) }}</td>
                    <td>{{ number_format($purchase->allocations->sum('allocated_amount')) }}</td>
                    <td>{{ number_format($purchase->total_amount - $purchase->allocations->sum('allocated_amount')) }}</td>
                    <td>
                        @if (($purchase->total_amount - $purchase->allocations->sum('allocated_amount')) <= 0)
                            <span class="badge paid">تسویه شده</span>
                            @else
                            <span class="badge pending">در حال تسویه</span>
                            @endif
                    </td>
                    <td>{{ $purchase->created_at->format('Y-m-d') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>


@endsection





