<?php $__env->startSection('title', 'عنوان صفحه'); ?>

<?php $__env->startSection('styles'); ?>
<style>
    body { font-family: 'B Nazanin', sans-serif; background-color: #f4f7f6; margin: 0; padding: 20px; }
    .container { max-width: 900px; margin: 0 auto; background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    h1 { text-align: center; color: #333; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { border: 1px solid #ddd; padding: 12px; text-align: center; }
    th { background-color: #f2f2f2; color: #555; }
    tr:nth-child(even) { background-color: #f9f9f9; }
    tr:hover { background-color: #f1f1f1; }
    a { text-decoration: none; color: #3498db; font-weight: bold; }
    a:hover { color: #2980b9; }
    .details { font-size: 0.9em; text-align: right; }
</style>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>
    <script>
        // اینجا کدهای جاوااسکریپت مخصوص این صفحه را قرار دهید
    </script>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('content'); ?>


    <div class="container">
        <h1>لیست فروش‌ها</h1>

       <table>
    <thead>
        <tr>
            <th>شناسه</th>
            <th>مشتری</th>
            <th>مبلغ فروش</th>
            <th>ثبت‌کننده</th>
            <th>تخصیص به خرید</th>
            <th>وضعیت</th> <th>تاریخ ثبت</th>
            <th>عملیات</th> </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($sale->id); ?></td>
                <td><?php echo e($sale->customer_name); ?></td>
                <td><?php echo e(number_format($sale->amount)); ?></td>
                <td><?php echo e($sale->user->name); ?></td>
                <td>
                    <?php $__currentLoopData = $sale->allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="details">
                            به خرید #<?php echo e($allocation->purchase_id); ?>: <?php echo e(number_format($allocation->allocated_amount)); ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                    <?php if($sale->status === 'پرداخت شده'): ?>
                        <span style="color: green; font-weight: bold;"><?php echo e($sale->status); ?></span>
                    <?php else: ?>
                        <span style="color: orange; font-weight: bold;"><?php echo e($sale->status); ?></span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($sale->created_at->format('Y-m-d')); ?></td>
                <td>
                    <?php if($sale->status !== 'پرداخت شده'): ?>
                        <a href="<?php echo e(route('sales.finalize', $sale->id)); ?>">
                            آپلود رسید و نهایی‌سازی
                        </a>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
    </div>


    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\ariya-varzesh\resources\views/sales/index.blade.php ENDPATH**/ ?>